/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.capability;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

@SerialClass
public class GolemConfigStorage {
    public static Capability<GolemConfigStorage> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<GolemConfigStorage>(){});
    private static GolemConfigStorage CACHE = null;
    public final Level level;
    @SerialClass.SerialField
    private final HashMap<UUID, GolemConfigEntry[]> storage = new HashMap();

    public static GolemConfigStorage get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            return (GolemConfigStorage)sl.m_7654_().m_129783_().getCapability(CAPABILITY).resolve().get();
        }
        return GolemConfigStorage.getClientCache(level);
    }

    private static GolemConfigStorage getClientCache(Level level) {
        if (CACHE == null || GolemConfigStorage.CACHE.level != level) {
            CACHE = new GolemConfigStorage(level);
        }
        return CACHE;
    }

    public GolemConfigStorage(Level level) {
        this.level = level;
    }

    public GolemConfigEntry getOrCreateStorage(UUID id, int color, Component comp) {
        GolemConfigEntry[] entries = this.storage.computeIfAbsent(id, k -> new GolemConfigEntry[16]);
        if (entries[color &= 0xF] == null) {
            entries[color] = GolemConfigEntry.getDefault(id, color, comp);
        }
        return entries[color].init(id, color);
    }

    @Nullable
    public GolemConfigEntry getStorage(UUID id, int color) {
        if (color < 0 || color > 15) {
            return null;
        }
        GolemConfigEntry[] entries = this.storage.computeIfAbsent(id, k -> new GolemConfigEntry[16]);
        GolemConfigEntry ans = entries[color];
        if (ans == null) {
            return null;
        }
        ans.init(id, color);
        return ans;
    }

    public void replaceStorage(GolemConfigEntry entry) {
        GolemConfigEntry[] entries = this.storage.computeIfAbsent(entry.getID(), k -> new GolemConfigEntry[16]);
        entries[entry.getColor()] = entry.copyFrom(entries[entry.getColor()]);
    }

    public void init() {
    }

    public static void register() {
    }
}

